/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.blockentities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.chickens.containers.ContainerHenhouse;
import net.creeperhost.chickens.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockEntityHenhouse
extends BlockEntity
implements MenuProvider {
    public static final int hayBaleEnergy = 100;
    public static final int hayBaleSlotIndex = 0;
    public static final int dirtSlotIndex = 1;
    public static final int firstItemSlotIndex = 2;
    private static final int lastItemSlotIndex = 10;
    private static final double HENHOUSE_RADIUS = 0.5;
    private static final double FENCE_THRESHOLD = 0.5;
    public final ItemStackHandler inventory = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntityHenhouse.this.m_6596_();
        }
    };
    public final ContainerData containerData = new SimpleContainerData(1){

        public int m_6413_(int index) {
            if (index == 0) {
                return BlockEntityHenhouse.this.getEnergy();
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }

        public void m_8050_(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int m_6499_() {
            return 1;
        }
    };
    private int energy = 0;

    public BlockEntityHenhouse(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.HEN_HOUSE_TILE.get(), blockPos, blockState);
    }

    @javax.annotation.Nullable
    public static ItemStack pushItemStack(ItemStack itemToLay, Level worldObj, Vec3 pos) {
        BlockEntityHenhouse henhouse;
        List<BlockEntityHenhouse> henhouses = BlockEntityHenhouse.findHenhouses(worldObj, pos, 5.0);
        Iterator<BlockEntityHenhouse> iterator = henhouses.iterator();
        while (iterator.hasNext() && !(itemToLay = (henhouse = iterator.next()).pushItemStack(itemToLay)).m_41619_()) {
        }
        return itemToLay;
    }

    private static List<BlockEntityHenhouse> findHenhouses(Level worldObj, Vec3 pos, double radius) {
        int firstChunkX = Mth.m_14107_((double)((pos.f_82479_ - radius - 100.0) / 16.0));
        int lastChunkX = Mth.m_14107_((double)((pos.f_82479_ + radius + 100.0) / 16.0));
        int firstChunkY = Mth.m_14107_((double)((pos.f_82481_ - radius - 100.0) / 16.0));
        int lastChunkY = Mth.m_14107_((double)((pos.f_82481_ + radius + 100.0) / 16.0));
        ArrayList<Double> distances = new ArrayList<Double>();
        ArrayList<BlockEntityHenhouse> result = new ArrayList<BlockEntityHenhouse>();
        for (int chunkX = firstChunkX; chunkX <= lastChunkX; ++chunkX) {
            for (int chunkY = firstChunkY; chunkY <= lastChunkY; ++chunkY) {
                LevelChunk chunk = worldObj.m_6325_(chunkX, chunkY);
                for (BlockEntity tileEntity : chunk.m_62954_().values()) {
                    Vec3 tileEntityPos;
                    boolean inRage;
                    if (!(tileEntity instanceof BlockEntityHenhouse) || !(inRage = BlockEntityHenhouse.testRange(pos, tileEntityPos = new Vec3((double)tileEntity.m_58899_().m_123341_(), (double)tileEntity.m_58899_().m_123342_(), (double)tileEntity.m_58899_().m_123343_()).m_82520_(0.5, 0.5, 0.5), radius))) continue;
                    double distance = pos.m_82554_(tileEntityPos);
                    BlockEntityHenhouse.addHenhouseToResults((BlockEntityHenhouse)tileEntity, distance, distances, result);
                }
            }
        }
        return result;
    }

    private static boolean testRange(Vec3 pos1, Vec3 pos2, double range) {
        return Math.abs(pos1.f_82479_ - pos2.f_82479_) <= range && Math.abs(pos1.f_82480_ - pos2.f_82480_) <= range && Math.abs(pos1.f_82481_ - pos2.f_82481_) <= range;
    }

    private static void addHenhouseToResults(BlockEntityHenhouse henhouse, double distance, List<Double> distances, List<BlockEntityHenhouse> henhouses) {
        for (int resultIndex = 0; resultIndex < distances.size(); ++resultIndex) {
            if (!(distance < distances.get(resultIndex))) continue;
            distances.add(resultIndex, distance);
            henhouses.add(resultIndex, henhouse);
            return;
        }
        distances.add(distance);
        henhouses.add(henhouse);
    }

    private ItemStack pushItemStack(ItemStack stack) {
        int capacity = this.getEffectiveCapacity();
        if (capacity <= 0) {
            return stack;
        }
        for (int slotIndex = 2; slotIndex <= 10 && !stack.m_41619_(); ++slotIndex) {
            ItemStack simulated;
            int stackSizePre = stack.m_41613_();
            int powerToUse = stackSizePre - (simulated = this.inventory.insertItem(slotIndex, stack, true)).m_41613_();
            if (powerToUse <= 0) continue;
            this.consumeEnergy(powerToUse);
            capacity -= powerToUse;
            stack = this.inventory.insertItem(slotIndex, stack, false);
        }
        this.m_6596_();
        return stack;
    }

    private void consumeEnergy(int amount) {
        while (amount > 0) {
            if (this.energy == 0) {
                this.inventory.extractItem(0, 1, false);
                this.energy += 100;
            }
            int consumed = Math.min(amount, this.energy);
            this.energy -= consumed;
            amount -= consumed;
            if (this.energy > 0) continue;
            this.inventory.insertItem(1, new ItemStack((ItemLike)Blocks.f_50493_, 1), false);
        }
    }

    private int getEffectiveCapacity() {
        return Math.min(this.getInputCapacity(), this.getOutputCapacity());
    }

    private int getInputCapacity() {
        int potential = this.energy;
        ItemStack hayBaleStack = this.inventory.getStackInSlot(0);
        if (!hayBaleStack.m_41619_() && hayBaleStack.m_41720_() == Item.m_41439_((Block)Blocks.f_50335_)) {
            potential += hayBaleStack.m_41613_() * 100;
        }
        return potential;
    }

    private int getOutputCapacity() {
        ItemStack dirtStack = this.inventory.getStackInSlot(1);
        if (dirtStack.m_41619_()) {
            return this.inventory.getSlotLimit(1) * 100;
        }
        if (dirtStack.m_41720_() != Item.m_41439_((Block)Blocks.f_50493_)) {
            return 0;
        }
        return (this.inventory.getSlotLimit(1) - dirtStack.m_41613_()) * 100;
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("energy", this.energy);
        compound.m_128391_(this.inventory.serializeNBT());
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.energy = compound.m_128451_("energy");
        this.inventory.deserializeNBT(compound);
    }

    public int getEnergy() {
        return this.energy;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    public Component m_5446_() {
        return new TranslatableComponent("container.henhouse");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new ContainerHenhouse(id, inventory, this, this.containerData);
    }
}

